library(lavaan)
library(semTools)
library("dplyr")
library("corrplot")
library("semPlot")
library(psych)
library(devtools)
library(MVN)
library(mirt)
library(knitr)      
scale <-(AB)
head(scale, 3)   

mod1 <- (mirt(scale, 1, verbose = FALSE, itemtype = 'graded', SE = TRUE))
M2(mod1, type = "C2", calcNULL = FALSE)
itemfit(mod1)
IRT_parms <- coef(mod1, IRTpars = TRUE, simplify = TRUE)
IRT_parms$items

plot(mod1, type='trace', which.item = c(1,2,3,4,5,6), facet_items=T, 
     as.table = TRUE, auto.key=list(points=F, lines=T, columns=4, space = 'top', cex = .8), 
     theta_lim = c(-3, 3), 
     main = "Category characteristic curves of Embodied Sense of Self")

plot(mod1, type='infotrace', which.item = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22), facet_items=T, 
     as.table = TRUE, auto.key=list(points=F, lines=T, columns=4, space = 'right', cex = .8), 
     theta_lim = c(-3, 3), 
     main="Item information curves of Embodied Sense of Self")
plot(mod1, type = 'infoSE', theta_lim = c(-3, 3), 
     main="Scale information and conditional standard errors of FEmbodied Sense of Self")
plot(mod1, type = 'score', theta_lim = c(-3, 3), main = " Scale characteristic curve of Fussion")
# Conditional reliability
plot(mod1, type = 'rxx', theta_lim = c(-3, 3), 
     main="Conditional reliability of Embodied Sense of Self" )
marginal_rxx(mod1)


model<-'N=~q1+q16+q22+q25
A=~q4+q8+q11+q13+q15+q17+q21+q24
o=~q5+q7+q10+q14+q23
'

fitMot4 <- lavaan::cfa(model, data = A)
summary(fitMot4 , standardized=TRUE, rsquare=TRUE, fit.measures=TRUE)
fitMeasures(fitMot4, "cfi")
fitMeasures(fitMot4, "gfi")
fitMeasures(fitMot4, "agfi")
fitMeasures(fitMot4, "acfi")
fitMeasures(fitMot4, "nfi")
fitMeasures( fitMot4,"nnfi")
fitMeasures(fitMot4, "rmsea")
fitMeasures(fitMot4, "srmr")
fitMeasures(fitMot4, "ifi") 
semPaths(fitMot4, what = " std.all", edge.label.cex = 0.7, edge.color = 1, esize = 1, sizeMan = 4.5, asize = 2.5, intercepts = FALSE, rotation = 4, thresholdColor = "red", mar = c(1, 5, 1.5, 5), fade = FALSE, nCharNodes = 4)

A$SEX=as.factor(A$SEX)
cfa.config <- cfa(model, data = A, group = "SEX")

summary(cfa.config, fit.measures = TRUE, standardized = TRUE)

cfa.metric <- cfa(model, data = A, group = "SEX", 
                  group.equal = "loadings")

Com<-compareFit(cfa.config, cfa.metric)
summary(Com)

cfa.scalar <- cfa(model, data = A, group = "SEX", group.equal = c("loadings","intercepts"))

Com2<-compareFit(cfa.metric, cfa.scalar)
summary(Com2)

reliability(fitMot4)
sl <- standardizedSolution(fitMot4)
sl <- sl$est.std[sl$op == "=~"]
re <- 1 - sl^2
CR <- sum(sl)^2 / (sum(sl)^2 + sum(re))
AVE <-  sum(sl^2)/17

mvn(A[,1:25], mvnTest="mardia")

